package gov.va.med.mhv.usermgmt.data.repository;

import gov.va.med.mhv.usermgmt.data.model.TermsConditionsVerHistory;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface TermsConditionsVerHistoryRepository extends JpaRepository<TermsConditionsVerHistory, Long> {

	@Query("Select t from TermsConditionsVerHistory t order by t.updatedTime desc")
	List<TermsConditionsVerHistory> getVersionByUpdateTime();

	@Query("Select t from TermsConditionsVerHistory t where t.id=:termsConditionsVerHistId")
	List<TermsConditionsVerHistory> getVersionById(@Param("termsConditionsVerHistId") Long termsConditionsVerHistId);
	
	@Query("Select t from UserAcceptTermsHistory u, TermsConditionsVerHistory t where t.id=u.termsCondVerHistId and u.userProfileId=:userProfileId and to_number(substr(t.versionInfo,2)) >= to_number(:version) order by u.userUpdatedTime desc")
	List<TermsConditionsVerHistory> getUserAcceptTermsVerHistByUserProfileId(@Param("userProfileId") Long userProfileId, @Param("version") String version);
	
}
